@extends('layouts.app')
@section('title', 'Performance Dashboard')

@section('content')
<section class="content-header">
  <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Performance Dashboard</h1>
  <small class="tw-text-gray-600">Last 24 hours</small>
  <div class="pull-right">
    <a href="{{ url()->current() }}" class="tw-dw-btn tw-dw-btn-sm tw-dw-btn-outline tw-dw-btn-primary">Refresh</a>
  </div>
</section>

<section class="content">
  @if(session('status'))
    @php $st = session('status'); @endphp
    <div class="alert alert-{{ !empty($st['success']) ? 'success' : 'danger' }}">{{ $st['msg'] ?? '' }}</div>
  @endif

  <div class="row">
    <div class="col-md-3">
      <div class="small-box bg-aqua">
        <div class="inner">
          <h3>{{ (int)($stats['slow_24h_count'] ?? 0) }}</h3>
          <p>Slow Queries (24h)</p>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="small-box bg-green">
        <div class="inner">
          <h3>{{ number_format((float)($stats['slow_24h_avg_ms'] ?? 0), 1) }} ms</h3>
          <p>Avg Slow Query Time</p>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="small-box bg-yellow">
        <div class="inner">
          <h3>{{ (int)($stats['slow_24h_max_ms'] ?? 0) }} ms</h3>
          <p>Longest Slow Query</p>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="small-box bg-light-blue">
        <div class="inner">
          <h3>{{ strtoupper($env['cache'] ?? 'file') }}</h3>
          <p>Cache Driver</p>
        </div>
      </div>
    </div>
  </div>

  <div class="box box-primary">
    <div class="box-header with-border">
      <h3 class="box-title">Environment</h3>
      <div class="box-tools">
        <form method="POST" action="{{ route('performance.clean') }}" class="form-inline" style="display:inline;">
          @csrf
          <label class="checkbox-inline"><input type="checkbox" name="purge_slow" value="1"> Purge slow logs older than</label>
          <input type="number" name="keep_days" min="0" value="7" class="form-control input-sm" style="width:80px;" />
          <button type="submit" class="btn btn-success btn-sm" style="background-color:#22c55e;border-color:#16a34a;color:#fff;">Clean Now</button>
        </form>
      </div>
    </div>
    <div class="box-body">
      <ul>
        <li>PHP: {{ $env['php'] ?? '' }}</li>
        <li>Laravel: {{ $env['laravel'] ?? '' }}</li>
        <li>Queue: {{ strtoupper($env['queue'] ?? '') }}</li>
        <li>OPcache: {{ !empty($env['opcache_enabled']) ? 'Enabled' : 'Disabled' }}</li>
      </ul>
    </div>
  </div>

  <div class="box box-primary">
    <div class="box-header with-border">
      <h3 class="box-title">Top Slow Queries (24h)</h3>
      <div class="box-tools">
        <a href="{{ route('performance.download') }}" class="btn btn-default btn-sm">
          <i class="fa fa-download"></i> Download CSV
        </a>
      </div>
    </div>
    <div class="box-body table-responsive">
      <table class="table table-striped">
        <thead>
          <tr>
            <th>Time (ms)</th>
            <th>SQL</th>
            <th>URL</th>
            <th>When</th>
          </tr>
        </thead>
        <tbody>
          @forelse($top as $row)
            <tr>
              <td>{{ (int)$row->time_ms }}</td>
              <td><code style="white-space: pre-wrap;">{{ Str::limit($row->sql, 300) }}</code></td>
              <td class="small">{{ $row->url }}</td>
              <td class="small">{{ @format_datetime($row->created_at) }}</td>
            </tr>
          @empty
            <tr><td colspan="4" class="text-center text-muted">No slow queries recorded in the last 24 hours.</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>

  @if(!empty($indexes))
  <div class="box box-primary">
    <div class="box-header with-border">
      <h3 class="box-title">Index Health</h3>
    </div>
    <div class="box-body table-responsive">
      <table class="table table-bordered">
        <thead>
          <tr>
            <th>Table</th>
            <th>Index</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          @foreach($indexes as $table => $list)
            @foreach($list as $idx)
              <tr>
                <td>{{ $table }}</td>
                <td>{{ $idx['name'] }}</td>
                <td>{!! $idx['present'] ? '<span class="label bg-green">Present</span>' : '<span class="label bg-red">Missing</span>' !!}</td>
              </tr>
            @endforeach
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
  @endif

</section>
@endsection
